#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
//#include "ctrl/BOLTReport.h"
#include "BOLTFrm.h"
#include "form/BOLTforms.h"
#include "form/bfReport.h"
#include "ctrl/BOLTBackup.h"

#include "ctrl/BOLTQuickPicks.h"

#include "report/brParam.h"
#include "report/brPreview.h"
#include "report/brTrigger.h"
#include "report/brQuery.h"
#include "report/brReport.h"
#include "report/brRunner.h"
#include "report/brTarget.h"

#include "wx/statline.h"
#include "wx/printdlg.h"
enum { ID_VIEW=26000,
		ID_PRINT,
		ID_SAVE,
		ID_SEND,
		ID_EDIT,
		ID_BS_BACKUP,
		ID_BS_BACKUPREPORTS,
		ID_BS_RESTORE,
		ID_BS_QUICKPICK
};

//IMPLEMENT_DYNAMIC_CLASS(bfReport,BOLTPage)
BEGIN_EVENT_TABLE(bfReport,BOLTPage)
EVT_BUTTON(ID_EDIT,bfReport::OnButton)
EVT_BUTTON(ID_VIEW,bfReport::OnButton)
EVT_BUTTON(ID_PRINT,bfReport::OnButton)
EVT_BUTTON(ID_SAVE,bfReport::OnButton)
EVT_BUTTON(ID_SEND,bfReport::OnButton)
EVT_BUTTON(ID_BS_QUICKPICK,bfReport::OnButton)
EVT_BUTTON(ID_BS_BACKUPREPORTS,bfReport::OnButton)
EVT_BUTTON(ID_BS_BACKUP,bfReport::OnButton)
EVT_BUTTON(ID_BS_RESTORE,bfReport::OnButton)
END_EVENT_TABLE()

bfReport::bfReport(wxNotebook *parent,BOLTdb *db,RECORD_ID recID):
	BOLTPage(parent,-1,wxDefaultPosition,wxDefaultSize,wxTAB_TRAVERSAL|wxWANTS_CHARS,"Report")
{
		wxString tStr;
		this->db=db;
		this->recordId=recID;
//		this->SetBackgroundColour(COLOR_REPORT);
wxBoxSizer *topSizer,*tmpSizer;
wxBoxSizer *cSizer,*bSizer,*dSizer;

topSizer=new wxBoxSizer(wxVERTICAL);
bSizer=new wxBoxSizer(wxHORIZONTAL);

if ((long)recordId==-1)
{ 
SetName("Stored Reports");
// Show the CustomTriggers
// Edit Reports Button
pPreview=NULL;
wxBoxSizer *hSizer=new wxBoxSizer(wxHORIZONTAL);
hSizer->Add(new brTarget(this,db,0),1,wxEXPAND|wxALL,0);

	wxButton *tButton;
	wxStaticBoxSizer *tSBS;
	wxStaticBox *tSB=NULL;


#define SBADD(b,t,h,c) tSBS=new wxStaticBoxSizer(\
		tSB=new wxStaticBox(this,-1,t),wxVERTICAL); \
		tSBS->Add(tButton=b,1,wxALIGN_CENTER|wxALL,5); \
		tButton->SetName("1"); \
		tButton->SetToolTip(h); \
		vSizer->Add(tSBS,1,wxALIGN_CENTER|wxALL,3);

	wxGridSizer *vSizer=new wxGridSizer(2,3);
#define BS_ADD(text,id,bitmap) \
		tmpSizer=new wxStaticBoxSizer(new wxStaticBox(this,-1,text),wxVERTICAL ); \
		tmpSizer->Add(new wxBitmapButton(this,id,bitmap),0,wxALL,5); \
		vSizer->Add(tmpSizer,0,wxALIGN_CENTER|wxALL,10);

	BS_ADD("Quick Picks",ID_BS_QUICKPICK,wxBitmap("BUTTONQUICKPICKS"))
	BS_ADD("Report Editor",ID_EDIT,wxBitmap("BUTTONTOOLS"))
	BS_ADD("Backup Reports",ID_BS_BACKUPREPORTS,BITMAP_REPORTS)
	BS_ADD("Backup Database",ID_BS_BACKUP,wxBitmap("BUTTONBACKUP"))
	BS_ADD("Restore",ID_BS_RESTORE,wxBitmap("BUTTONRESTORE"))
	SBADD(BUTTON_LOGOUT,"&Logout",HELP_LOGOUT,"");

  wxAcceleratorEntry entries[6];
  entries[0].Set(wxACCEL_ALT,  (int) 'R',     ID_REPORTS);
  entries[1].Set(wxACCEL_ALT,  (int) 'O',     ID_SETTINGS);
  entries[2].Set(wxACCEL_ALT,  (int) 'L',     ID_LOGOUT);
  entries[3].Set(wxACCEL_ALT,  (int) 'R',     ID_REPORTS);
  entries[4].Set(wxACCEL_ALT,  (int) 'O',     ID_SETTINGS);
  entries[5].Set(wxACCEL_ALT,  (int) 'L',     ID_LOGOUT);
   wxAcceleratorTable accel(6, entries);
  SetAcceleratorTable(accel);  
  
  hSizer->Add(vSizer,1,wxEXPAND|wxALL,5);
  topSizer->Add(hSizer,1,wxEXPAND|wxALL,5);
//topSizer->Add(new wxStaticLine(this,-1),0,wxEXPAND);
//bSizer->Add(new wxButton(this,ID_EDIT,"&Advanced Report Edit"),0,wxALIGN_CENTER|wxALL,5);
//bSizer->Add(new wxButton(this,ID_CLOSEPAGE,"&Close"),0,wxALIGN_CENTER|wxALL,5);
//topSizer->Add(bSizer,0,wxALIGN_CENTER|wxALL,5);
this->FindWindow(ID_EDIT)->SetFocus();
}
else
{
tStr=db->GetValue("reports","name",recID);
SetName(tStr);


dSizer=new wxBoxSizer(wxHORIZONTAL);

pPreview=new brPreview(this,db,recID);

cSizer=new wxBoxSizer(wxVERTICAL);
cSizer->Add(new brReport(this,db,recID,pPreview),0,wxEXPAND|wxALL,0);
cSizer->Add(new wxStaticLine(this,-1),0,wxEXPAND);
cSizer->Add(new brTrigger(this,db,recID),0,wxEXPAND|wxALL,0);
cSizer->Add(new wxStaticLine(this,-1),0,wxEXPAND);
cSizer->Add(new brParam(this,db,recID),0,wxEXPAND|wxALL,0);

dSizer->Add(cSizer,0,wxEXPAND|wxALL,0);
cSizer=new wxBoxSizer(wxVERTICAL);
cSizer->Add(new brQuery(this,db,recID,pPreview),1,wxEXPAND|wxALL,0);
dSizer->Add(cSizer,0,wxEXPAND|wxALL,0);

cSizer=new wxBoxSizer(wxVERTICAL);
cSizer->Add(pPreview,1,wxEXPAND|wxALL,0);


bSizer->Add(new wxButton(this,ID_VIEW,"View"),0,wxALIGN_CENTER|wxALL,5);
bSizer->Add(new wxButton(this,ID_PRINT,"Print"),0,wxALIGN_CENTER|wxALL,5);
cSizer->Add(bSizer,0,wxALIGN_CENTER|wxALL,5);
bSizer=new wxBoxSizer(wxHORIZONTAL);
bSizer->Add(new wxButton(this,ID_SAVE,"Save"),0,wxALIGN_CENTER|wxALL,5);
bSizer->Add(new wxButton(this,ID_SEND,"Send"),0,wxALIGN_CENTER|wxALL,5);
cSizer->Add(bSizer,0,wxALIGN_CENTER|wxALL,5);
dSizer->Add(cSizer,1,wxEXPAND|wxALL,0);

topSizer->Add(dSizer,1,wxEXPAND|wxALL,0);

}
//SetAutoLayout(TRUE);
SetSizerAndFit(topSizer);

if (pPreview) { pPreview->Refresh(); };
  FitInside();
	}

void bfReport::OnButton(wxCommandEvent &event)
{
	wxString path,server,user,pass;
//	bool textonly,passive;
	wxPageSetupDialogData pdData=wxGetApp().frame->psData;
	wxPrintData printData;
	wxPageSetupDialog *pDlg;
	brRunner *runner;
	wxFileDialog *wFD;
	int p;

BOLTBackup *backup;
BOLTUserManager *bUM;
BOLTQuickPicks *bQP;

	switch(event.GetId())
	{
	case ID_BS_BACKUP:
			backup=new BOLTBackup(db,this);
			backup->DoBackup();
			backup->Destroy();
		break;
	case ID_BS_BACKUPREPORTS:
			backup=new BOLTBackup(db,this);
			backup->DoBackupReports();
			backup->Destroy();
		break;
	case ID_BS_RESTORE:
			backup=new BOLTBackup(db,this);
			backup->DoRestore();
			backup->Destroy();
		break;
	case ID_BS_QUICKPICK:
		bQP=new BOLTQuickPicks(this,db);
		bQP->Destroy();
		break;
	case ID_EDIT:
		wxGetApp().frame->DispatchForm(ID_REPORTS,0);
/*		bc=new BOLTChooser(db,this,-1);
		bc->AddQuickPicks("Home Reports");
		reportId=bc->GetChoice();
		if (reportId>0)
		{ wxGetApp().frame->DispatchForm(ID_REPORTS,reportId); }*/
		break;
	case ID_VIEW:
		runner=new brRunner(this,db,recordId);
			p=0; do { p++;
		runner->DoViewReport(recordId,p);
			} while (runner->HasMorePages());
		break;
	safe_delete(runner);
	case ID_PRINT:
	runner=new brRunner(this,db,recordId);
		pdData.EnableMargins(TRUE);
		pDlg=new wxPageSetupDialog(this,&pdData);
		if (pDlg->ShowModal()==wxID_OK)
		{ 
			pdData=pDlg->GetPageSetupData();
//			pdData.EnableMargins(TRUE);
//			pdData.SetMarginTopLeft(wxPoint(0,0));
//			pdData.SetMarginBottomRight(wxPoint(0,0));
			wxGetApp().frame->psData=pdData;
//			printData=pdData.GetPrintData();
			p=0; do { p++;
			runner->DoPrintReport(recordId,pdData.GetPrintData(),p);
			} while (runner->HasMorePages());
		}
		pDlg->Destroy();//delete pDlg;
	safe_delete(runner);
		break;
	case ID_SAVE:
	runner=new brRunner(this,db,recordId);
		wFD=new wxFileDialog(this,"Save report to where ?","","BOLT_Report.txt","Text File|*.txt|Jpeg Image|*.jpg",wxSAVE|wxOVERWRITE_PROMPT);
		if (wFD->ShowModal()==wxID_OK)
		{
			path=wFD->GetPath();
			p=0; do { p++;
			runner->DoSaveReport(recordId,path,path.AfterLast('.')=="txt",p);
			} while (runner->HasMorePages());
		}
		wFD->Destroy();

			/*		path=wxFileSelector("Save to where","","","jpg","Jpeg Image|*.jpg|Text File|*.txt",wxSAVE|wxOVERWRITE_PROMPT,this);
		if (!path.IsEmpty())
		{
			runner->DoSaveReport(recordId,path,path.AfterLast('.')=="txt");
		}*/
	safe_delete(runner);
		break;
	case ID_SEND:
	runner=new brRunner(this,db,recordId);
		path=wxGetTextFromUser("Enter the connect string in the format\nuser:password@host/path/to/file","Ftp Destination","",this);
		if (!path.IsEmpty()){
			p=0; do { p++;
			runner->DoSendReport(recordId,path.AfterFirst('/'),path.AfterLast('@').BeforeFirst('/'),path.BeforeFirst('@').BeforeFirst(':'),
				path.BeforeFirst('@').AfterLast(':'),path.AfterLast('.').IsSameAs("txt"),true,p);
			} while (runner->HasMorePages());
		}
	safe_delete(runner);
		break;
	}
}
